// LAB:11 - Perform the Linear Block Coding on binary Data.
// Version : Scilab 5.4.1
// Operating System : Window-xp, Window-7

clc;
close;
clear;
xdel(winsid());

global P n k;

n=7;
k=4;
P=[1 1 0; 0 1 1; 1 0 1;1 1 1]; //% parity  matrix of size k*(n-k) to be 
//                               % selected so that the systematic generator   
//                               % matrix is linearly independent or full rank 
//                               % matrix


//%This is an linear block encoding function file%

function y1=linblkcode(x);
global P n k;
G=[eye(k,k) P]; 

y1=zeros(1,n);
for i=1:k
    var(i,:)=x(1,i) & G(i,:);           
    var(i,:)=bool2s(var(i,:));
    y1(1,:)=bitxor(var(i,:),y1(1,:));
end

endfunction


//%This is a linear block syndrome decoding function file%

function x1=linblkdecoder(y)
//% here y is recieved vector 7 bits long(7,4) linear block code 

global P n k;

 
//H=[ ]; //% PARITY CHECK MATRIX 
 
H=[P' eye((n-k),(n-k))];
Ht=H'; //%transpose of H
 
S=zeros(1,n-k); //%syndrome of recieved vector x
for i=1:n-k
    S(i)=y(1) & Ht(1,i);
    S(i)=bool2s(S(i));
    for j=2:n
        
        S(i)=bitxor(S(i), bool2s((y(j) & Ht(j,i))));
    end
end
//%%****SYNDROME LOOK UP TABLE************
if S==[0 0 0]
   e=[0 0 0 0 0 0 0];
    z=bitxor(y,e);
end
 
if S==[0 0 1]
   e=[0 0 0 0 0 0 1];
    z=bitxor(y,e);
end
if S==[0 1 0]
   e=[0 0 0 0 0 1 0];
    z=bitxor(y,e);
end
if S==[1 0 0]
   e=[0 0 0 0 1 0 0];
    z=bitxor(y,e);
end
if S==[1 1 1]
   e=[0 0 0 1 0 0 0];
    z=bitxor(y,e);
end
if S==[1 0 1]
   e=[0 0 1 0 0 0 0];
    z=bitxor(y,e);
end
if S==[0 1 1]
   e=[0 1 0 0 0 0 0];
    z=bitxor(y,e);
end
if S==[1 1 0]
   e=[1 0 0 0 0 0 0];
    z=bitxor(y,e);
end

x1=z(1,1:k);
endfunction

///////////////////// Main Programm //////////////////////
x=[0 1 0 1];   //                % input bits to the encoder of size 1* k
y1=linblkcode(x);//           //   % y1 is the output of linear block encoder

e1=[1 0 0 0 0 0 0];           // % intentionally error introduced after 
//                               % encoding and before sending to decoder (in 
  //                             % this case pls introduce only one bit error)
y=bitxor(y1,e1);//               % input that will be made available to linear 
                  //             % block decoder

x1=linblkdecoder(y) //           % x1 is the output of the linear block decoder
                      //         % which will be same as x provided that here 
                        //       % have introduced only one bit error

disp('The information signal=')
disp(x)
disp('The transmitted encoded signal=')
disp(y1)
disp('The recieved signal=')
disp(y)
disp('The decoded signal=')
disp(x1)


///////////////////////// Input and Output Values////////////////////////
//The information signal(x)=[0 1 0 1];
//The transmitted encoded signal(y1)=[0 1 0 1 1 0 0];
//The recieved signal(y)=[1 1 0 1 1 0 0];
//The decoded signal(x1)=[0 1 0 1];
